﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class GetServiceAppointmentStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
                state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
            if (state.ServiceAppointment == null) throw new Exception("Service Appointment cannot be null");
        }
    }
}
